#ifndef __gui__dialog__settings_h
#define __gui__dialog__settings_h

#include "core/anime.h"
#include "core/config.h"
#include "core/session.h"
#include <QDialog>
#include <QWidget>
#include <QLocale>
#include <QListWidget>

class QLabel;
class QTabWidget;
class QStackedWidget;
class SideBar;

/* !!! MOVE THIS ELSEWHERE! */
class DroppableListWidget : public QListWidget {
	Q_OBJECT

public:
	explicit DroppableListWidget(QWidget* parent);

signals:
	void FilesDropped(QStringList list);

protected:
	void dragEnterEvent(QDragEnterEvent* event) override;
	void dragMoveEvent(QDragMoveEvent* event) override;
	void dropEvent(QDropEvent* event) override;
};

class SettingsPage : public QWidget {
		Q_OBJECT

	public:
		SettingsPage(QWidget* parent = nullptr, QString title = "");
		void SetTitle(QString title);
		virtual void SaveInfo() = 0;
		void AddTab(QWidget* tab, QString title = "");

	private:
		QLabel* page_title;
		QTabWidget* tab_widget;
};

class SettingsPageServices final : public SettingsPage {
		Q_OBJECT

	public:
		SettingsPageServices(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateMainPage();
		QWidget* CreateAniListPage();

		decltype(session.config.service) service;
};

class SettingsPageApplication final : public SettingsPage {
		Q_OBJECT

	public:
		SettingsPageApplication(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateAnimeListWidget();
		QWidget* CreateGeneralWidget();

		Themes theme;
		QLocale locale;

		decltype(session.config.anime_list.score_format) format;
		decltype(session.config.anime_list.language) language;
		decltype(session.config.anime_list.display_aired_episodes) display_aired_episodes;
		decltype(session.config.anime_list.display_available_episodes) display_available_episodes;
		decltype(session.config.anime_list.highlight_anime_if_available) highlight_anime_if_available;
		decltype(session.config.anime_list.highlighted_anime_above_others) highlighted_anime_above_others;
};

class SettingsPageTorrents final : public SettingsPage {
		Q_OBJECT

	public:
		SettingsPageTorrents(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateGeneralWidget();

		decltype(session.config.torrents.feed_link) feed_link;
};

class SettingsPageRecognition final : public SettingsPage {
		Q_OBJECT

	public:
		SettingsPageRecognition(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreatePlayersWidget();

		decltype(session.config.recognition.detect_media_players) detect_media_players;
		decltype(session.config.recognition.players) players;
};

class SettingsPageLibrary final : public SettingsPage {
		Q_OBJECT

	public:
		SettingsPageLibrary(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateFoldersWidget();

		decltype(session.config.library.paths) paths;
		decltype(session.config.library.real_time_monitor) real_time_monitor;
};

class SettingsDialog final : public QDialog {
		Q_OBJECT

	public:
		SettingsDialog(QWidget* parent = nullptr);
		QWidget* CreateServicesMainPage(QWidget* parent);
		void OnOK();

	protected:
		void showEvent(QShowEvent* event) override;

	private:
		SideBar* sidebar;
		QStackedWidget* stacked;
};

#endif // __gui__dialog__settings_h
