#ifndef __core__ini_h
#define __core__ini_h

#define MINI_CASE_SENSITIVE
#include "mini/ini.h"
#include "core/strings.h"
#include "gui/translate/anime.h"
#include "gui/translate/config.h"
#include <type_traits>
#include <string>

namespace INI {

/* very simple tutorial on how to give anyone who reads
   your code an aneurysm */
template <typename T, typename = void>
struct is_toutf8string_available : std::false_type {};

template<typename T>
struct is_toutf8string_available<T,
		std::void_t<decltype(Strings::ToUtf8String(std::declval<T>()))>> : std::true_type {};

template <typename T, typename = void>
struct is_translation_available : std::false_type {};

template<typename T>
struct is_translation_available<T,
		std::void_t<decltype(Translate::ToString(std::declval<T>()))>> : std::true_type {};

template<typename T>
T GetIniValue(const mINI::INIStructure& ini, const std::string& section,
	          const std::string& value, const T& def) {
	if (!ini.has(section) || !ini.get(section).has(value))
		return def;

	const std::string val = ini.get(section).get(value);

	if constexpr (std::is_integral<T>::value) {
		/* Integer? */
		if constexpr (std::is_same<T, bool>::value) {
			/* Boolean? */
			return Strings::ToBool(val, def);
		} else {
			/* Always fall back to long long */
			return Strings::ToInt<T>(val, def);
		}
	} else {
		return val;
	}
}

/* this should be able to handle most of our custom types */
template<typename T>
void SetIniValue(mINI::INIStructure& ini, const std::string& section,
	             const std::string& key, const T& value) {
	auto& ini_key = ini[section][key];

	if constexpr (is_translation_available<T>::value) {
		/* prioritize translation */
		ini_key = Translate::ToString(value);
	} else if constexpr (std::is_same<T, std::string>::value) {
		/* lmfao */
		ini_key = value;
	} else if constexpr (is_toutf8string_available<T>::value) {
		ini_key = Strings::ToUtf8String(value);
	}
}

}

#endif
