#include "gui/pages/seasons.h"

#include "core/anime_db.h"
#include "gui/widgets/anime_button.h"
#include "gui/layouts/flow_layout.h"

#include <QVBoxLayout>
#include <QToolBar>
#include <QFrame>
#include <QListWidget>
#include <QListWidgetItem>

SeasonsPage::SeasonsPage(QWidget* parent) : QWidget(parent) {
	QVBoxLayout* full_layout = new QVBoxLayout(this);

	{
		/* Toolbar */
		QToolBar* toolbar = new QToolBar(this);
		toolbar->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
		toolbar->setIconSize(QSize(16, 16));
		toolbar->setMovable(false);

		{
			/* this needs to be stored somewhere to replicate Taiga's
			   "timer" feature */
			toolbar->addAction("Aids");
		}

		toolbar->addSeparator();

		{
			toolbar->addAction(QIcon(":/icons/16x16/navigation-270-button.png"), tr("Download &marked torrents"));
		}

		{
			toolbar->addAction(QIcon(":/icons/16x16/cross-button.png"), tr("&Discard all"));
		}

		toolbar->addSeparator();

		{
			toolbar->addAction(QIcon(":/icons/16x16/gear.png"), tr("&Settings"));
		}

		full_layout->addWidget(toolbar);
	}

	{
		QFrame* line = new QFrame(this);
		line->setFrameShape(QFrame::HLine);
		line->setFrameShadow(QFrame::Sunken);
		line->setLineWidth(1);
		full_layout->addWidget(line);
	}

	{
		buttons = new QListWidget(this);
		buttons->setFlow(QListView::LeftToRight);
		buttons->setWrapping(true);
		buttons->setContentsMargins(4, 4, 4, 4);
		buttons->setSpacing(2);
		buttons->setResizeMode(QListView::Adjust);

		{
			QListWidgetItem* item = new QListWidgetItem;
			AnimeButton* button = new AnimeButton(this);
			button->SetAnime(Anime::db.items[Anime::db.GetAnimeFromTitle("Another")]);
			item->setSizeHint(button->sizeHint());
			buttons->addItem(item);
			buttons->setItemWidget(item, button);
		}
		{
			QListWidgetItem* item = new QListWidgetItem;
			AnimeButton* button = new AnimeButton(this);
			button->SetAnime(Anime::db.items[Anime::db.GetAnimeFromTitle("Another")]);
			item->setSizeHint(button->sizeHint());
			buttons->addItem(item);
			buttons->setItemWidget(item, button);
		}
		{
			QListWidgetItem* item = new QListWidgetItem;
			AnimeButton* button = new AnimeButton(this);
			button->SetAnime(Anime::db.items[Anime::db.GetAnimeFromTitle("Another")]);
			item->setSizeHint(button->sizeHint());
			buttons->addItem(item);
			buttons->setItemWidget(item, button);
		}
		{
			QListWidgetItem* item = new QListWidgetItem;
			AnimeButton* button = new AnimeButton(this);
			button->SetAnime(Anime::db.items[Anime::db.GetAnimeFromTitle("Another")]);
			item->setSizeHint(button->sizeHint());
			buttons->addItem(item);
			buttons->setItemWidget(item, button);
		}

		full_layout->addWidget(buttons);
	}
}
