#ifndef MINORI_SYS_X11_SETTINGS_H_
#define MINORI_SYS_X11_SETTINGS_H_

#include <cstdint>
#include <string>
#include <vector>

namespace x11 {

/* stores the item, type, etc */
struct SettingsItem {
	enum Type {
		TypeInt = 0,
		TypeStr = 1,
		TypeRgba = 2,
	};

	/* could technically be a union */
	struct Data {
		std::uint32_t integer;
		std::string string;
		struct {
			std::uint16_t red, green, blue, alpha;
		} rgba;
	};

	bool VerifyType();

	std::uint8_t type;    /* one of Type */
	std::string name;     /* name of the item */
	std::uint32_t serial; /* last-changed serial */
	Data data;            /* type-specific data */
};

bool GetSettings(std::vector<SettingsItem>& settings);
bool FindSetting(const std::string& name, SettingsItem& setting);

}

#endif /* MINORI_SYS_X11_SETTINGS_H_ */