#include "core/http.h"
#include "core/session.h"
#include <QByteArray>
#include <curl/curl.h>
#include <string>
#include <vector>
#include <iostream>

namespace HTTP {

static size_t WriteCallback(void* contents, size_t size, size_t nmemb, void* userdata) {
	reinterpret_cast<QByteArray*>(userdata)->append(reinterpret_cast<char*>(contents), size * nmemb);
	return size * nmemb;
}

QByteArray Get(const std::string& url, const std::vector<std::string>& headers) {
	struct curl_slist* list = NULL;
	QByteArray userdata;

	CURL* curl = curl_easy_init();
	if (curl) {
		for (const std::string& h : headers) {
			list = curl_slist_append(list, h.c_str());
		}
		curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
		curl_easy_setopt(curl, CURLOPT_HTTPHEADER, list);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &userdata);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &WriteCallback);
		/* Use system certs... useful on Windows. */
		curl_easy_setopt(curl, CURLOPT_SSL_OPTIONS, CURLSSLOPT_NATIVE_CA);
		curl_easy_setopt(curl, CURLOPT_NOSIGNAL, 1); // threading
		CURLcode res = curl_easy_perform(curl);
		session.IncrementRequests();
		curl_easy_cleanup(curl);
		if (res != CURLE_OK)
			std::cerr << "curl_easy_perform(curl) failed!: " << curl_easy_strerror(res) << std::endl;
	}
	return userdata;
}

QByteArray Post(const std::string& url, const std::string& data, const std::vector<std::string>& headers) {
	struct curl_slist* list = NULL;
	QByteArray userdata;

	CURL* curl = curl_easy_init();
	if (curl) {
		for (const std::string& h : headers) {
			list = curl_slist_append(list, h.c_str());
		}
		curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
		curl_easy_setopt(curl, CURLOPT_POSTFIELDS, data.c_str());
		curl_easy_setopt(curl, CURLOPT_HTTPHEADER, list);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &userdata);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, &WriteCallback);
		/* Use system certs... useful on Windows. */
		curl_easy_setopt(curl, CURLOPT_SSL_OPTIONS, CURLSSLOPT_NATIVE_CA);
		curl_easy_setopt(curl, CURLOPT_NOSIGNAL, 1); // threading
		CURLcode res = curl_easy_perform(curl);
		session.IncrementRequests();
		curl_easy_cleanup(curl);
		if (res != CURLE_OK)
			std::cerr << "curl_easy_perform(curl) failed!: " << curl_easy_strerror(res) << std::endl;
	}
	return userdata;
}

} // namespace HTTP
