#include "animia/fd.h"

#ifdef WIN32
#	include "animia/fd/win32.h"
#elif defined(LINUX)
#	include "animia/fd/linux.h"
#elif defined(MACOSX)
#	include "animia/fd/xnu.h"
#endif

namespace animia::internal {

#ifdef WIN32
win32::Win32FdTools os_fd;
#elif defined(LINUX)
linux::LinuxFdTools os_fd;
#elif defined(MACOSX)
xnu::XnuFdTools os_fd;
#else
BaseFdTools os_fd;
#endif

BaseFdTools& fd = os_fd;

}
