#ifndef __gui__ui_utils_h
#define __gui__ui_utils_h

#include <QWidget>
#include <QString>
#include <QSize>
#include <QPlainTextEdit>
#include <QLineEdit>

class QFrame;
class QLabel;

namespace TextWidgets {

class Header : public QWidget {
		Q_OBJECT

	public:
		Header(QString title, QWidget* parent = nullptr);
		void SetText(QString title);

	private:
		QLabel* static_text_title;
		QFrame* static_text_line;
};

class Paragraph : public QPlainTextEdit {
		Q_OBJECT

	public:
		Paragraph(QString text, QWidget* parent = nullptr);
		void SetText(QString text);
		QSize minimumSizeHint() const override;
		QSize sizeHint() const override;
};

class Line : public QLineEdit {
		Q_OBJECT

	public:
		Line(QString text, QWidget* parent = nullptr);
};

class Title : public Line {
		Q_OBJECT

	public:
		Title(QString title, QWidget* parent = nullptr);
};

class Section : public QWidget {
		Q_OBJECT

	public:
		Section(QString title, QString data, QWidget* parent = nullptr);
		Header* GetHeader();
		Paragraph* GetParagraph();

	private:
		Header* header;
		Paragraph* paragraph;
};

class LabelledSection : public QWidget {
		Q_OBJECT

	public:
		LabelledSection(QString title, QString label, QString data, QWidget* parent = nullptr);
		Header* GetHeader();
		Paragraph* GetLabels();
		Paragraph* GetParagraph();

	private:
		Header* header;
		Paragraph* labels;
		Paragraph* paragraph;
};

class SelectableSection : public QWidget {
		Q_OBJECT

	public:
		SelectableSection(QString title, QString data, QWidget* parent = nullptr);
		Header* GetHeader();
		Paragraph* GetParagraph();

	private:
		Header* header;
		Paragraph* paragraph;
};

class OneLineSection : public QWidget {
		Q_OBJECT

	public:
		OneLineSection(QString title, QString data, QWidget* parent = nullptr);
		Header* GetHeader();
		Line* GetLine();

	private:
		Header* header;
		Line* line;
};

} // namespace TextWidgets

#endif // __gui__ui_utils_h
