#include "core/anime.h"
#include "core/session.h"
#include "core/strings.h"
#include "gui/dialog/settings.h"
#include "services/anilist.h"
#include <QComboBox>
#include <QGroupBox>
#include <QPushButton>
#include <QSizePolicy>
#include <QVBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QLineEdit>

QWidget* SettingsPageServices::CreateMainPage() {
	QWidget* result = new QWidget(this);
	result->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QGroupBox* sync_group_box = new QGroupBox(tr("Synchronization"), result);
	sync_group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QLabel* sync_combo_box_label = new QLabel(tr("Active service and metadata provider:"), sync_group_box);

	QComboBox* sync_combo_box = new QComboBox(sync_group_box);
	sync_combo_box->addItem(tr("AniList"));
	connect(sync_combo_box, QOverload<int>::of(&QComboBox::currentIndexChanged), this,
	        [this](int index) { service = static_cast<Anime::Services>(index + 1); });
	sync_combo_box->setCurrentIndex(static_cast<int>(service) - 1);

	QLabel* sync_note_label =
	    new QLabel(tr("Note: Minori is unable to synchronize multiple services at the same time."), sync_group_box);

	QVBoxLayout* sync_layout = new QVBoxLayout(sync_group_box);
	sync_layout->addWidget(sync_combo_box_label);
	sync_layout->addWidget(sync_combo_box);
	sync_layout->addWidget(sync_note_label);

	QVBoxLayout* full_layout = new QVBoxLayout(result);
	full_layout->addWidget(sync_group_box);
	full_layout->setSpacing(10);
	full_layout->addStretch();

	return result;
}

QWidget* SettingsPageServices::CreateAniListPage() {
	QWidget* result = new QWidget(this);
	result->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);

	QGroupBox* group_box = new QGroupBox(tr("Account"), result);
	group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	/* this is outdated! usernames are retrieved through a request to AniList now.
	       although that's a bit... erm... cancerous, maybe this method IS useful. IDK */
	QLabel* username_entry_label = new QLabel(tr("Username: (not your email address)"), group_box);

	QWidget* auth_widget = new QWidget(group_box);
	QLineEdit* username_entry = new QLineEdit(username, auth_widget);
	connect(username_entry, &QLineEdit::editingFinished, this,
	        [this, username_entry] { username = username_entry->text(); });

	QPushButton* auth_button = new QPushButton(auth_widget);
	connect(auth_button, &QPushButton::clicked, this, [] { Services::AniList::AuthorizeUser(); });
	auth_button->setText(session.config.anilist.auth_token.empty() ? tr("Authorize...") : tr("Re-authorize..."));

	QHBoxLayout* auth_layout = new QHBoxLayout(auth_widget);
	auth_layout->addWidget(username_entry);
	auth_layout->addWidget(auth_button);

	QLabel* note_label = new QLabel(tr("<a href=\"http://anilist.co/\">Create a new AniList account</a>"), group_box);
	note_label->setTextFormat(Qt::RichText);
	note_label->setTextInteractionFlags(Qt::TextBrowserInteraction);
	note_label->setOpenExternalLinks(true);

	QVBoxLayout* layout = new QVBoxLayout(group_box);
	layout->addWidget(username_entry_label);
	layout->addWidget(auth_widget);
	layout->addWidget(note_label);

	QVBoxLayout* full_layout = new QVBoxLayout(result);
	full_layout->addWidget(group_box);
	full_layout->setSpacing(10);
	full_layout->addStretch();
	return result;
}

void SettingsPageServices::SaveInfo() {
	// session.config.anilist.username = 
Strings::ToUtf8String(username);
	session.config.service = service;
}

SettingsPageServices::SettingsPageServices(QWidget* parent) : SettingsPage(parent, tr("Services")) {
	username = QString::fromUtf8(session.config.anilist.username.c_str());
	service = session.config.service;
	AddTab(CreateMainPage(), tr("Main"));
	AddTab(CreateAniListPage(), tr("AniList"));
}
