#ifndef __core__filesystem_h
#define __core__filesystem_h
#include <string>

namespace Filesystem {

bool CreateDirectories(const std::string& path);
bool Exists(const std::string& path);
std::string Basename(const std::string& path);
std::string Stem(const std::string& path);
std::string GetParentDirectory(const std::string& path);
std::string GetDotPath(); // %APPDATA%/minori, ~/Library/Application Support/minori, ~/.config/minori...
std::string GetConfigPath(); // (dotpath)/config.json
std::string GetAnimeDBPath(); // (dotpath)/anime/db.json

} // namespace Filesystem

#endif // __core__filesystem_h
