#ifndef __animia__animia__fd_h
#define __animia__animia__fd_h

#include <set>
#include <string>
#include <functional>

#include "animia/types.h"

namespace animia {

struct Process;

namespace internal {

struct OpenFile {
	pid_t pid = 0;
	std::string path;
};

using process_proc_t = std::function<bool(const Process&)>;

using open_file_proc_t = std::function<bool(const OpenFile&)>;

class BaseFdTools {
	public:
		virtual ~BaseFdTools() {}
		virtual bool EnumerateOpenProcesses(process_proc_t process_proc) { return false; }
		virtual bool EnumerateOpenFiles(const std::set<pid_t>& pids, open_file_proc_t open_file_proc) { return false; }
};

extern BaseFdTools& fd; // defined in fd.cc

} // namespace internal

} // namespace animia

#endif // __animia__animia__fd_h
