#include <windows.h>
#include <subauth.h>

#include <string>
#include <memory>

namespace animia::internal::win32 {

struct HandleDeconstructor {
	using pointer = HANDLE;
	void operator()(pointer t) const { ::CloseHandle(t); };
};

using Handle = std::unique_ptr<HANDLE, HandleDeconstructor>;

/* ----------------------------------------------- */

std::string ToUtf8String(const std::wstring& string);
std::string ToUtf8String(const UNICODE_STRING& string);
std::wstring ToWstring(const std::string& string);

std::wstring GetFileNameFromPath(const std::wstring& path);
std::wstring GetFileNameWithoutExtension(const std::wstring& filename);

bool IsSystemDirectory(const std::string& path);
bool IsSystemDirectory(std::wstring path);

}