#include <string>
#include <vector>
#include <set>

#include "animia.h"
#include "animia/strategies.h"
#include "animia/types.h"
#include "animia/fd.h"

namespace animia {

static bool ProcessInPlayers(const std::vector<Player>& players, const std::string& name, Player& player_) {
	for (const auto& player : players) {
		for (const auto& exe : player.executables) {
			if (exe == name.substr(0, name.rfind(".exe"))) {
				player_ = player;
				return true;
			}
		}
	}
	return false;
}

bool GetResults(const std::vector<Player>& players, std::vector<Result>& results) {
	std::set<internal::pid_t> pids;

	if (!internal::fd.GetAllPids(pids))
		return false;

	for (const auto& pid : pids) {
		std::string name;
		internal::fd.GetProcessName(pid, name);

		Player player;
		if (!ProcessInPlayers(players, name, player))
			continue;

		Result result;
		result.process.pid = pid;
		result.process.name = name;
		result.player = player;
		results.push_back(result);
	}

	return internal::ApplyStrategies(results);
}

}
