#ifndef MINORI_GUI_PAGES_ANIME_LIST_H_
#define MINORI_GUI_PAGES_ANIME_LIST_H_

#include "core/anime.h"
#include <QAbstractListModel>
#include <QSortFilterProxyModel>
#include <QStyledItemDelegate>
#include <QWidget>
#include <QThread>
#include <vector>
#include <queue>

class QTreeView;
class QTabBar;
class AnimeListPage;

class AnimeListPageUpdateEntryThread final : public QThread {
	Q_OBJECT

public:
	AnimeListPageUpdateEntryThread(AnimeListPage* parent);

	void AddToQueue(int id);

signals:
	void NeedRefresh();

protected:
	void run() override;

private:
	AnimeListPage* page_ = nullptr;
	std::mutex _queue_mutex;
	std::queue<int> queue_;
};

class AnimeListPageSortFilter final : public QSortFilterProxyModel {
	Q_OBJECT

public:
	AnimeListPageSortFilter(QObject* parent = nullptr);

protected:
	bool lessThan(const QModelIndex& l, const QModelIndex& r) const override;
};

class AnimeListPageModel final : public QAbstractListModel {
	Q_OBJECT

public:
	enum columns {
		AL_TITLE,
		AL_PROGRESS,
		AL_EPISODES,
		AL_SCORE,
		AL_AVG_SCORE,
		AL_TYPE,
		AL_SEASON,
		AL_STARTED,
		AL_COMPLETED,
		AL_UPDATED,
		AL_NOTES,

		NB_COLUMNS
	};

	AnimeListPageModel(QObject* parent, Anime::ListStatus _status);
	~AnimeListPageModel() override = default;
	int rowCount(const QModelIndex& parent = QModelIndex()) const override;
	int columnCount(const QModelIndex& parent = QModelIndex()) const override;
	QVariant data(const QModelIndex& index, int role) const override;
	QVariant headerData(const int section, const Qt::Orientation orientation, const int role) const override;
	void RefreshList();
	Anime::Anime* GetAnimeFromIndex(QModelIndex index);

private:
	Anime::ListStatus status;
	std::vector<Anime::Anime> list;
};

class AnimeListPage final : public QWidget {
	Q_OBJECT

public:
	AnimeListPage(QWidget* parent = nullptr);

public slots:
	void Refresh();

protected:
	void paintEvent(QPaintEvent*) override;
	void InitStyle(QStyleOptionTabWidgetFrame* option) const;
	void InitBasicStyle(QStyleOptionTabWidgetFrame* option) const;
	void SetupLayout();
	void showEvent(QShowEvent*) override;
	void resizeEvent(QResizeEvent* e) override;
	void RefreshList();
	void RefreshTabs();
	void UpdateAnime(int id);
	void RemoveAnime(int id);

private slots:
	void DisplayColumnHeaderMenu();
	void DisplayListMenu();
	void ItemDoubleClicked();
	void SetColumnDefaults();
	int VisibleColumnsCount() const;

private:
	QTabBar* tab_bar;
	QTreeView* tree_view;
	QRect panelRect;

	AnimeListPageUpdateEntryThread update_entry_thread_;
	std::array<AnimeListPageSortFilter*, 5> sort_models;
};

#endif // MINORI_GUI_PAGES_ANIME_LIST_H_
