#ifndef MINORI_GUI_WIDGETS_SIDEBAR_H_
#define MINORI_GUI_WIDGETS_SIDEBAR_H_

#include <QItemSelectionModel>
#include <QListWidget>

class QListWidgetItem;

class SideBar final : public QListWidget {
	Q_OBJECT

public:
	SideBar(QWidget* parent = nullptr);
	QListWidgetItem* AddItem(QString name, QIcon icon = QIcon());
	QListWidgetItem* AddSeparator();
	int GetCurrentItem();
	bool IndexIsSeparator(QModelIndex index) const;
	static QIcon CreateIcon(const char* file);
	void SetBackgroundTransparent(bool yes);

signals:
	void CurrentItemChanged(int index);

public slots:
	void SetCurrentItem(int index);

protected:
	virtual void mouseMoveEvent(QMouseEvent* event) override;
	QItemSelectionModel::SelectionFlags selectionCommand(const QModelIndex& index, const QEvent* event) const override;
	int RemoveSeparatorsFromIndex(int index);
	int AddSeparatorsToIndex(int index);
};

#endif // MINORI_GUI_WIDGETS_SIDEBAR_H_
