#include "core/anime.h"
#include "core/anime_db.h"
#include "core/date.h"
#include "core/session.h"
#include "core/http.h"
#include "core/strings.h"
#include "gui/window.h"
#include "services/anilist.h"

#include <QApplication>
#include <QLocale>
#include <QStyleFactory>
#include <QTranslator>

#include <cstdlib>

int main(int argc, char **argv)
{
	HTTP::Initializer http;

	QApplication app(argc, argv);
	app.setApplicationName("minori");
	app.setApplicationDisplayName("Minori");
	app.setAttribute(Qt::AA_DontShowIconsInMenus, true);

	qRegisterMetaType<std::vector<std::string>>(); /* window.cc */
	qRegisterMetaType<std::vector<int>>();         /* search.cc */
	qRegisterMetaType<std::string>();
	qRegisterMetaType<Anime::Season>();

	session.config.Load();
	Anime::db.LoadDatabaseFromDisk();

	MainWindow window;

	window.resize(941, 750);
	window.setWindowTitle("Minori");
	window.show();

	/* do this before starting the app... */
	session.SetMainWindow(&window);

	return app.exec();
}
