#include "animia/fd.h"

#ifdef ANIMIA_ON_WIN32
#	include "animia/fd/win32.h"
#elif defined(ANIMIA_ON_LINUX)
#	include "animia/fd/linux.h"
#elif defined(ANIMIA_ON_UNIX)
#	include "animia/fd/bsd.h"
#endif

namespace animia::internal {

/* really stupid hack to get fd to point to the right
   thing */
#ifdef ANIMIA_ON_WIN32
win32::Win32FdTools os_fd;
#elif defined(ANIMIA_ON_LINUX)
linux::LinuxFdTools os_fd;
#elif defined(ANIMIA_ON_UNIX)
unix::UnixFdTools os_fd;
#else
BaseFdTools os_fd;
#endif

BaseFdTools& fd = os_fd;

}
