#include <string>
#include <vector>
#include <set>

#include "animia.h"
#include "animia/strategies.h"
#include "animia/types.h"
#include "animia/fd.h"

namespace animia {

static bool ProcessInPlayers(const std::vector<Player>& players, std::string name, Player& player_) {
	for (const auto& player : players) {
		for (const auto& exe : player.executables) {
			/* this is only really relevant on Windows, and even then
			   executables can end in any number of extensions, so we should
			   really remove them all... */
			auto pos = name.rfind(".exe");
			if (pos != std::string::npos)
				name = name.substr(0, pos);

			if (exe == name) {
				player_ = player;
				return true;
			}
		}
	}
	return false;
}

bool GetResults(const std::vector<Player>& players, std::vector<Result>& results) {
	std::set<internal::pid_t> pids;

	if (!internal::fd.GetAllPids(pids))
		return false;

	for (const auto& pid : pids) {
		std::string name;
		internal::fd.GetProcessName(pid, name);

		Player player;
		if (!ProcessInPlayers(players, name, player))
			continue;

		Result result;
		result.process.pid = pid;
		result.process.name = name;
		result.player = player;
		results.push_back(result);
	}

	return internal::ApplyStrategies(results);
}

}
