#include "animia/strategies.h"
#include "animia/util.h"
#include "animia/fd.h"
#include "animia.h"

namespace animia::internal {

class Strategist {
	public:
		Strategist(Result& result) : result_(result) {}

		bool ApplyStrategies();

	private:
		bool AddMedia(const MediaInfo media_information);

		bool ApplyOpenFilesStrategy();

		Result& result_;
};

bool Strategist::ApplyStrategies() {
	bool success = false;

	for (const auto strategy : result_.player.strategies) {
		switch (strategy) {
			case Strategy::OpenFiles:
				success |= ApplyOpenFilesStrategy();
				break;
		}
	}

	return success;
}

bool ApplyStrategies(std::vector<Result>& results) {
	bool success = false;

	for (auto& result : results) {
		Strategist strategist(result);
		success |= strategist.ApplyStrategies();
	}

	return success;
}

////////////////////////////////////////////////////////////////////////////////

bool Strategist::ApplyOpenFilesStrategy() {
	bool success = false;

	const std::set<pid_t> pids{result_.process.pid};
	std::vector<std::pair<pid_t, std::string>> files;

	fd.EnumerateOpenFiles(pids, files);

	for (const auto& [pid, file] : files) {
		success |= AddMedia({MediaInfoType::File, file});
	}

	return success;
}

////////////////////////////////////////////////////////////////////////////////

bool Strategist::AddMedia(const MediaInfo media_information) {
	if (media_information.value.empty())
		return false;

	Media media;
	media.information.push_back(media_information);
	result_.media.push_back(std::move(media));

	return true;
}

}
