#include "gui/widgets/optional_date.h"
#include <QCheckBox>
#include <QDateEdit>
#include <QHBoxLayout>

OptionalDate::OptionalDate(QWidget* parent) {
	OptionalDate(false, parent);
}

OptionalDate::OptionalDate(bool enabled, QWidget* parent) : QWidget(parent) {
	QHBoxLayout* layout = new QHBoxLayout(this);
	layout->setMargin(0);

	_checkbox = new QCheckBox(this);
	_checkbox->setCheckState(enabled ? Qt::Checked : Qt::Unchecked);
	_checkbox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Preferred);

	layout->addWidget(_checkbox, 0, Qt::AlignVCenter);

	_dateedit = new QDateEdit(this);
	_dateedit->setDisplayFormat("yyyy-MM-dd");
	_dateedit->setCalendarPopup(true);
	_dateedit->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred);

	layout->addWidget(_dateedit);

	SetEnabled(enabled);
	connect(_checkbox, &QCheckBox::stateChanged, this, [this](int state) { SetEnabled(state == Qt::Checked); });
}

void OptionalDate::SetEnabled(bool enabled) {
	_dateedit->setEnabled(enabled);
}

bool OptionalDate::IsEnabled() {
	return _dateedit->isEnabled();
}

void OptionalDate::SetDate(QDate date) {
	_dateedit->setDate(date);
}

QDateEdit* OptionalDate::GetDateEdit() {
	return _dateedit;
}

QCheckBox* OptionalDate::GetCheckBox() {
	return _checkbox;
}
