#ifndef __animia__animia__fd__win32_h
#define __animia__animia__fd__win32_h

#include <vector>
#include <tuple>
#include <string>
#include <set>
#include <memory>

#include <windows.h>

#include "animia/types.h"
#include "animia/fd.h"

namespace animia::internal::win32 {

struct HandleDeconstructor {
	using pointer = HANDLE;
	void operator()(pointer t) const { ::CloseHandle(t); };
};

using Handle = std::unique_ptr<HANDLE, HandleDeconstructor>;

class Win32FdTools final : public BaseFdTools {
	public:
		bool GetAllPids(std::set<pid_t>& pids) override;
		bool GetProcessName(pid_t pid, std::string& result) override;
		bool EnumerateOpenFiles(const std::set<pid_t>& pids, std::vector<std::tuple<pid_t, std::string>>& files) override;
};

}

#endif // __animia__animia__fd__win32_h
