#ifndef MINORI_WINDOW_H_
#define MINORI_WINDOW_H_
#include "core/config.h"
#include <QMainWindow>
#include <memory>

/* *could* be forward-declared, but this causes
   any file that #includes this to have to #include
   these as well due to unique_ptr */
#include "gui/widgets/sidebar.h"
#include <QCloseEvent>
#include <QStackedWidget>
#include <QThread>
#include <QTimer>
#include <QWidget>

class QMenu;
class AnimeListPage;

Q_DECLARE_METATYPE(std::vector<std::string>);

class MainWindowPlayingThread final : public QThread {
	Q_OBJECT

public:
	MainWindowPlayingThread(QObject* object = nullptr) : QThread(object) {}

protected:
	void run() override;

signals:
	void Done(const std::vector<std::string>& files);
};

class MainWindowAsyncSynchronizeThread final : public QThread {
	Q_OBJECT

public:
	MainWindowAsyncSynchronizeThread(QAction* action, AnimeListPage* page, QObject* object = nullptr);
	void SetAction(QAction* action);
	void SetPage(AnimeListPage* page);

protected:
	void run() override;

private:
	QAction* action_ = nullptr;
	AnimeListPage* page_ = nullptr;
};

class MainWindow final : public QMainWindow {
	Q_OBJECT

public:
	enum class Pages {
		NOW_PLAYING,

		ANIME_LIST,
		HISTORY,
		STATISTICS,

		SEARCH,
		SEASONS,
		TORRENTS
	};

	MainWindow(QWidget* parent = nullptr);
	void SetActivePage(QWidget* page);
	void CreateBars();
	void AddMainWidgets();
	void RetranslateUI();
	void UpdateFolderMenu();
	void AsyncSynchronize(QAction* action, QStackedWidget* stack);
	void changeEvent(QEvent* event) override;
	void showEvent(QShowEvent* event) override;
	void closeEvent(QCloseEvent* event) override;

private:
	QWidget main_widget_;
	QStackedWidget stack_;
	SideBar sidebar_;

	MainWindowPlayingThread playing_thread_;
	QTimer playing_thread_timer_;

	MainWindowAsyncSynchronizeThread async_synchronize_thread_;

	QMenu* folder_menu = nullptr;
};

#endif // MINORI_WINDOW_H_
