#include "gui/pages/now_playing.h"
#include "core/anime_db.h"
#include "core/strings.h"
#include "gui/widgets/anime_info.h"
#include "gui/widgets/poster.h"
#include "gui/widgets/text.h"
#include "services/services.h"
#include "core/session.h"

#include <QHBoxLayout>
#include <QLabel>
#include <QStackedWidget>
#include <QVBoxLayout>
#include <QWidget>

#include <iostream>

#include "anitomy/anitomy.h"

namespace NowPlayingPages {
// TODO the "now playing" logic should NOT be located here; this should
// only be a frontent. THAT logic should at the very least be in the
// "core" subdirectory

Default::Default(QWidget *parent) : QWidget(parent)
{
	QVBoxLayout *layout = new QVBoxLayout(this);
	layout->setContentsMargins(0, 0, 0, 0);

	title_.SetText(Strings::Translate("Now Playing"));
	layout->addWidget(&title_);

	layout->addStretch();
}

Playing::Playing(QWidget *parent) : QWidget(parent)
{
	QHBoxLayout *layout = new QHBoxLayout(this);

	_main.setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);

	QVBoxLayout *main_layout = new QVBoxLayout(&_main);
	main_layout->setContentsMargins(0, 0, 0, 0);

	main_layout->addWidget(&_title);

	_info.setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
	_info.layout()->setContentsMargins(0, 0, 0, 0);
	main_layout->addWidget(&_info);

	/* "sidebar", includes... just the anime image :) */
	QVBoxLayout *sidebar_layout = new QVBoxLayout(&_sidebar);
	sidebar_layout->setContentsMargins(0, 0, 0, 0);

	sidebar_layout->addWidget(&_poster);

	sidebar_layout->addStretch();

	layout->addWidget(&_sidebar);
	layout->addWidget(&_main);
	layout->setSpacing(10);
	layout->setContentsMargins(0, 0, 0, 0);
}

int Playing::GetPlayingAnime()
{
	return _id;
}

int Playing::GetPlayingEpisode()
{
	return _episode;
}

bool Playing::SetPlayingAnime(const Anime::Anime &anime, const anitomy::Elements &info)
{
	if (_id == anime.GetId() &&
	    _episode == Strings::ToInt(Strings::ToUtf8String(info.get(anitomy::kElementEpisodeNumber))))
		return false;
	_id = anime.GetId();
	_episode = Strings::ToInt(Strings::ToUtf8String(info.get(anitomy::kElementEpisodeNumber)));
	_title.SetText(anime.GetUserPreferredTitle());
	_info.SetAnime(anime);
	_poster.SetAnime(anime);

	updateGeometry();
	return true;
}

} // namespace NowPlayingPages

NowPlayingPage::NowPlayingPage(QWidget *parent) : QFrame(parent)
{
	setBackgroundRole(QPalette::Base);
	QVBoxLayout *layout = new QVBoxLayout(this);

	setFrameShape(QFrame::Box);
	setFrameShadow(QFrame::Sunken);
	setAutoFillBackground(true);

	stack_.addWidget(&default_);
	stack_.addWidget(&playing_);
	layout->addWidget(&stack_);

	SetDefault();
}

void NowPlayingPage::SetDefault()
{
	/* 'timer_' is the time elapsed since we were set to the 'playing'
	 * mode. Otherwise it is -1. */
	if (timer_ != -1) {
		std::int64_t elapsed = session.uptime() - timer_;

		/* FIXME hardcoding the interval length is a hack at best
		 * (18 * 60 * 1000), is 18 minutes. */
		if (elapsed > (18ll * 60ll * 1000ll)) {
			/* Episode has finished playing */
			TimerDone();
		}

		/* Reset the timer */
		timer_ = -1;
	}

	stack_.setCurrentIndex(static_cast<int>(Subpages::Default));
}

int NowPlayingPage::GetPlayingId()
{
	return playing_.GetPlayingAnime();
}

void NowPlayingPage::SetPlaying(const Anime::Anime &anime, const anitomy::Elements &info)
{
	if (playing_.SetPlayingAnime(anime, info))
		timer_ = session.uptime();

	stack_.setCurrentIndex(static_cast<int>(Subpages::Playing));
	updateGeometry();
}

void NowPlayingPage::TimerDone(void)
{
	Anime::Anime &anime = Anime::db.items[playing_.GetPlayingAnime()];

	if (!anime.IsInUserList())
		anime.AddToUserList();

	const int progress = anime.GetUserProgress();
	const int playing_ep = playing_.GetPlayingEpisode();

	if (progress > playing_ep) {
		anime.SetUserProgress(playing_ep);
		Services::UpdateAnimeEntry(anime.GetId());
	}
}
