#ifndef MINORI_GUI_PAGES_SEARCH_H_
#define MINORI_GUI_PAGES_SEARCH_H_

#include "core/anime.h"

#include <QAbstractListModel>
#include <QFrame>
#include <QItemSelection>
#include <QSortFilterProxyModel>
#include <QThread>

class QTreeView;

class SearchPageSearchThread : public QThread {
	Q_OBJECT

public:
	SearchPageSearchThread(QObject* parent = nullptr);
	void SetSearch(const std::string& search);

protected:
	void run() override;

private:
	std::string search_;

signals:
	void GotResults(const std::vector<int>& search);
};

class SearchPageListSortFilter final : public QSortFilterProxyModel {
	Q_OBJECT

public:
	SearchPageListSortFilter(QObject* parent = nullptr);

protected:
	bool lessThan(const QModelIndex& l, const QModelIndex& r) const override;
};

class SearchPageListModel final : public QAbstractListModel {
	Q_OBJECT

public:
	enum columns {
		SR_TITLE,
		SR_TYPE,
		SR_EPISODES,
		SR_SCORE,
		SR_SEASON,

		NB_COLUMNS
	};

	SearchPageListModel(QObject* parent);
	~SearchPageListModel() override = default;
	int rowCount(const QModelIndex& parent = QModelIndex()) const override;
	int columnCount(const QModelIndex& parent = QModelIndex()) const override;
	QVariant data(const QModelIndex& index, int role) const override;
	QVariant headerData(const int section, const Qt::Orientation orientation, const int role) const override;
	Qt::ItemFlags flags(const QModelIndex& index) const override;

	void ParseSearch(const std::vector<int>& ids);
	Anime::Anime* GetAnimeFromIndex(const QModelIndex& index) const;

private:
	std::vector<int> ids;
};

class SearchPage final : public QFrame {
	Q_OBJECT

public:
	SearchPage(QWidget* parent = nullptr);
	void Search(const std::string& search);
	void DisplayListMenu();
	void ItemDoubleClicked();

private:
	SearchPageListModel* model = nullptr;
	SearchPageListSortFilter* sort_model = nullptr;
	QTreeView* treeview = nullptr;

	SearchPageSearchThread thread_;
};
#endif // MINORI_GUI_PAGES_SEARCH_H_
