#ifndef MINORI_GUI_WIDGETS_OPTIONAL_DATE_H_
#define MINORI_GUI_WIDGETS_OPTIONAL_DATE_H_

#include "core/date.h"
#include <QWidget>

class QCheckBox;
class QDateEdit;
class QDate;

class OptionalDate final : public QWidget {
	Q_OBJECT

public:
	OptionalDate(QWidget* parent = nullptr);
	OptionalDate(bool enabled, QWidget* parent = nullptr);
	QDateEdit* GetDateEdit();
	QCheckBox* GetCheckBox();
	void SetDate(QDate date);
	void SetDate(Date date);
	Date GetDate();
	void SetEnabled(bool enabled);
	bool IsEnabled();

signals:
	void DataChanged(bool checked, Date date);

private:
	QDateEdit* _dateedit;
	QCheckBox* _checkbox;
};

#endif // MINORI_GUI_WIDGETS_OPTIONAL_DATE_H_
