#ifndef MINORI_GUI_WIDGETS_ANIME_INFO_H_
#define MINORI_GUI_WIDGETS_ANIME_INFO_H_

#include <QWidget>
#include <QThread>
#include "gui/widgets/text.h"

#include <mutex>
#include <queue>

namespace Anime {
class Anime;
}

class AnimeInfoWidgetGetMetadataThread final : public QThread {
	Q_OBJECT

public:
	AnimeInfoWidgetGetMetadataThread(QObject* parent = nullptr);

	void AddToQueue(int id);

signals:
	void NeedRefresh(int id);

protected:
	void run() override;

private:
	std::mutex queue_mutex_;
	std::queue<int> queue_;
};

class AnimeInfoWidget final : public QWidget {
	Q_OBJECT

public:
	AnimeInfoWidget(QWidget* parent = nullptr);
	AnimeInfoWidget(const Anime::Anime& anime, QWidget* parent = nullptr);
	void SetAnime(const Anime::Anime& anime);

protected:
	void RefreshGenres(const Anime::Anime& anime);

private:
	TextWidgets::OneLineSection _title;
	TextWidgets::LabelledSection _details;
	TextWidgets::SelectableSection _synopsis;

	int id_ = 0;
};

#endif // MINORI_GUI_WIDGETS_ANIME_INFO_H_
