#ifndef MINORI_GUI_DIALOG_INFORMATION_H_
#define MINORI_GUI_DIALOG_INFORMATION_H_

#include "core/anime.h"
#include "core/date.h"
#include <QDialog>
#include <functional>

class InformationDialog final : public QDialog {
	Q_OBJECT

public:
	enum Pages {
		PAGE_MAIN_INFO,
		PAGE_MY_LIST
	};

	InformationDialog(Anime::Anime* anime, std::function<void(Anime::Anime*)> accept = {}, enum Pages page = Pages::PAGE_MAIN_INFO,
	                  QWidget* parent = nullptr);

protected:
	void showEvent(QShowEvent* event) override;

private:
	void SaveData(Anime::Anime* anime);
	unsigned int _progress;
	unsigned int _score;
	bool _rewatching;
	Anime::ListStatus _status;
	std::string _notes;
	Date _started;
	Date _completed;
};

#endif // MINORI_GUI_DIALOG_INFORMATION_H_
