#include "animia/win.h"

#ifdef WIN32
#	include "animia/win/win32.h"
#endif

#ifdef MACOSX
#	include "animia/win/quartz.h"
#endif

#ifdef X11
#	include "animia/win/x11.h"
#endif

#ifdef WAYLAND
#	include "animia/win/wayland.h"
#endif

namespace animia::internal {

bool EnumerateWindows(window_proc_t window_proc) {
	bool success = false;

#ifdef WIN32
	success |= win32::EnumerateWindows(window_proc);
#endif

#ifdef MACOSX
	success |= quartz::EnumerateWindows(window_proc);
#endif

#ifdef X11
	success |= x11::EnumerateWindows(window_proc);
#endif

#ifdef WAYLAND
	success |= wayland::EnumerateWindows(window_proc);
#endif

	return success;
}

} // namespace animia::internal
