#!/bin/sh
#
# deploys needed libraries for minori on win32
#
# this also runs windeployqt to deploy qt crap
# as well

DIR="${DIR:-minori}"

GetNeededLibraries() {
	# do not run this on untrusted executables.
	# see: ldd(1)
	ldd "$1" | while IFS="" read -r dependency; do
		fields=($dependency)
		lib="${fields[2]}"
		if [[ "$lib" == /"${MSYSTEM,,}"/* ]]; then
			echo "$lib"
		fi
	done
}

if [ -d "$DIR" ]; then
	rm -r "$DIR"
fi

mkdir "$DIR"

for lib in $(GetNeededLibraries ".libs/minori.exe"); do
	cp "$lib" "$DIR/"
done

cp ".libs/minori.exe" "$DIR/"

windeployqt "$DIR/minori.exe"

zip -r "$DIR.zip" "$DIR"
