#ifndef __core__date_h
#define __core__date_h
#include "json.h"
#include <QDate>
#include <cstdint>
class Date {
	public:
		Date();
		Date(int32_t y);
		Date(int32_t y, int8_t m, int8_t d);
		bool IsValid() const;
		void SetYear(int32_t y);
		void SetMonth(int8_t m);
		void SetDay(int8_t d);
		void VoidYear();
		void VoidMonth();
		void VoidDay();
		int32_t GetYear() const;
		int8_t GetMonth() const;
		int8_t GetDay() const;
		QDate GetAsQDate() const;
		nlohmann::json GetAsAniListJson() const;
		bool operator<(const Date& other) const;
		bool operator>(const Date& other) const;
		bool operator<=(const Date& other) const;
		bool operator>=(const Date& other) const;

	private:
		std::shared_ptr<int32_t> year;
		std::shared_ptr<int8_t> month;
		std::shared_ptr<int8_t> day;
};
#endif // __core__date_h
