#ifndef __core__strings_h
#define __core__strings_h

#include <string>
#include <vector>

class QString;

namespace Strings {

/* Implode function: takes a vector of strings and turns it
   into a string, separated by delimiters. */
std::string Implode(const std::vector<std::string>& vector, const std::string& delimiter);

/* Substring removal functions */
std::string ReplaceAll(std::string string, const std::string& find, const std::string& replace);
std::string SanitizeLineEndings(const std::string& string);
std::string RemoveHtmlTags(std::string string);
std::string ParseHtmlEntities(std::string string);

/* stupid HTML bullshit */
std::string TextifySynopsis(const std::string& string);

std::string ToUpper(const std::string& string);
std::string ToLower(const std::string& string);

/* functions that make the way we convert from and to
   different string formats universal */
std::wstring ToWstring(const std::string& string);
std::wstring ToWstring(const QString& string);
std::string ToUtf8String(const std::wstring& wstring);
std::string ToUtf8String(const QString& string);
QString ToQString(const std::string& string);
QString ToQString(const std::wstring& wstring);

}; // namespace Strings

#endif // __core__strings_h