#ifndef MINORI_GUI_WIDGETS_TEXT_H_
#define MINORI_GUI_WIDGETS_TEXT_H_

#include <QLineEdit>
#include <QPlainTextEdit>
#include <QSize>
#include <QString>
#include <QWidget>

class QFrame;

#include <QLabel>

namespace TextWidgets {

class Header : public QWidget {
	Q_OBJECT

public:
	Header(const QString& title, QWidget* parent = nullptr);
	void SetText(const QString& title);

private:
	QLabel* static_text_title;
	QFrame* static_text_line;
};

class Paragraph : public QLabel {
	Q_OBJECT

public:
	Paragraph(const QString& text, QWidget* parent = nullptr);
	void SetText(const QString& text);
};

class LabelledParagraph final : public QWidget {
	Q_OBJECT

public:
	LabelledParagraph(const QString& label, const QString& data, QWidget* parent = nullptr);
	Paragraph* GetLabels();
	Paragraph* GetParagraph();

private:
	Paragraph* labels;
	Paragraph* paragraph;
};

class Line : public Paragraph {
	Q_OBJECT

public:
	Line(QWidget* parent = nullptr);
	Line(const QString& text, QWidget* parent = nullptr);
	void SetText(const QString& text);
};

class Title final : public Line {
	Q_OBJECT

public:
	Title(const QString& title, QWidget* parent = nullptr);
};

class Section final : public QWidget {
	Q_OBJECT

public:
	Section(const QString& title, const QString& data, QWidget* parent = nullptr);
	Header* GetHeader();
	Paragraph* GetParagraph();

private:
	Header* header;
	Paragraph* paragraph;
};

class LabelledSection final : public QWidget {
	Q_OBJECT

public:
	LabelledSection(const QString& title, const QString& label, const QString& data, QWidget* parent = nullptr);
	Header* GetHeader();
	Paragraph* GetLabels();
	Paragraph* GetParagraph();

private:
	Header* header;
	LabelledParagraph* content;
};

class SelectableSection final : public QWidget {
	Q_OBJECT

public:
	SelectableSection(const QString& title, const QString& data, QWidget* parent = nullptr);
	Header* GetHeader();
	Paragraph* GetParagraph();

private:
	Header* header;
	Paragraph* paragraph;
};

class OneLineSection final : public QWidget {
	Q_OBJECT

public:
	OneLineSection(const QString& title, const QString& data, QWidget* parent = nullptr);
	Header* GetHeader();
	Line* GetLine();

private:
	Header* header;
	Line* line;
};

} // namespace TextWidgets

#endif // MINORI_GUI_WIDGETS_TEXT_H_
