# Animia
Animia is a work-in-progress cross-platform hard fork of Anisthesia and part of
Minori.

Most (if not all) Anisthesia configs should also work in this library as well
(at least on Windows).

## Support
Animia supports Windows, macOS, and Linux when dealing with file descriptors.
When enumerating windows, it supports Windows, macOS (Quartz), X11, and
Wayland (only via the `ext_foreign_toplevel_handle_v1` and
`wlr_foreign_toplevel_management_unstable_v1` interfaces).

Unlike Anisthesia, Animia currently does not support UI automation, i.e., most
web browsers will not work properly, if at all.

## Platform-specific quirks

### Windows
To get the currently opened file handles on Windows, Animia has to use internal
kernel functions. However, these functions aren't likely to change anytime soon.

### macOS
The code to retrieve executable names on macOS uses internal functions. However,
if these functions cannot be found for whatever reason, it falls back to parsing
the arguments, and then to calling the kernel.

Additionally, macOS does not have the concept of class names, rather, it has
bundle identifiers, which are a suitable replacement in most use cases, and are
what Animia will try to grab before falling back to the Quartz window name.

### X11
If your X server has the XRes extension installed, Animia will use it to get
PIDs. Otherwise, X11 has no idea what PID started your window. As a result,
what Animia will give you is from the `_NET_WM_PID` resource, which is
[very](https://stackoverflow.com/a/49970490)
[unreliable](https://stackoverflow.com/a/49970271).

### Wayland
Only Wayland servers that implement the `ext_foreign_toplevel_handle_v1` or
`wlr_foreign_toplevel_management_unstable_v1` interfaces will work with Animia.
Currently, both Sway and Mir support the latter. Maybe some day we'll have
major compositor support for `ext_foreign_toplevel_handle_v1`.
