#ifndef __core__config_h
#define __core__config_h

#include "core/anime.h"
#include "gui/theme.h"
#include "gui/locale.h"

#include "animia/player.h"

#include <string>
#include <vector>
#include <set>
#include <utility>

struct MediaPlayer {
	bool enabled = true;
	animia::Player player;
};

class Config {
	public:
		int Load();
		int Save() const;

		Anime::Services service;
		Theme::Theme theme;
		Locale::Locale locale;

		struct {
			Anime::TitleLanguage language;
			Anime::ScoreFormat score_format;
			bool display_aired_episodes;
			bool display_available_episodes;
			bool highlight_anime_if_available;
			bool highlighted_anime_above_others;
		} anime_list;

		/* these should preferably be in an
		   "auth" struct... */
		struct {
			struct {
				std::string auth_token;
				std::string username;
				int user_id;
			} anilist;
		} auth;

		struct {
			bool detect_media_players;
			std::vector<MediaPlayer> players;
		} recognition;

		struct {
			std::string feed_link;
		} torrents;

		struct {
			bool real_time_monitor;
			std::set<std::string> paths;
		} library;
};

#if (defined(WIN32) || defined(MACOSX))
constexpr std::string_view CONFIG_DIR = "Minori";
#else
constexpr std::string_view CONFIG_DIR = "minori";
#endif

constexpr std::string_view CONFIG_NAME = "config.ini";

#endif // __core__config_h
