#ifndef __core__json_h
#define __core__json_h

#include "json/json.h"

namespace JSON {

template<typename T = std::string>
T GetString(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr, T def) {
	if (json.contains(ptr) && json[ptr].is_string())
		return json[ptr].get<T>();
	else
		return def;
}

template<typename T = int>
T GetNumber(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr, T def = 0) {
	if (json.contains(ptr) && json[ptr].is_number())
		return json[ptr].get<T>();
	else
		return def;
}

template<typename T = std::vector<std::string>>
T GetArray(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr, T def = 0) {
	if (json.contains(ptr) && json[ptr].is_array())
		return json[ptr].get<T>();
	else
		return def;
}

nlohmann::json GetValue(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr);
bool GetBoolean(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr, bool def = false);

} // namespace JSON

#endif // __core__json_h