#include "core/json.h"

namespace JSON {

nlohmann::json GetValue(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr) {
	if (json.contains(ptr))
		return json.at(ptr);
	else
		return nlohmann::json();
}

bool GetBoolean(const nlohmann::json& json, const nlohmann::json::json_pointer& ptr, bool def) {
	if (json.contains(ptr) && json[ptr].is_boolean())
		return json[ptr].get<bool>();
	else
		return def;
}

} // namespace JSON
