#ifndef MINORI_GUI_WIDGETS_POSTER_H_
#define MINORI_GUI_WIDGETS_POSTER_H_
#include <QFrame>
#include <QImage>

#include "gui/widgets/clickable_label.h"
#include "core/http.h"

namespace Anime {
class Anime;
}

class Poster final : public QFrame {
	Q_OBJECT

public:
	Poster(QWidget* parent = nullptr);
	Poster(const Anime::Anime& anime, QWidget* parent = nullptr);
	~Poster();
	void SetAnime(const Anime::Anime& anime);
	void SetClickable(bool clickable);

protected:
	void showEvent(QShowEvent*) override;
	void resizeEvent(QResizeEvent*) override;
	void ImageDownloadFinished(const QByteArray& arr);
	void RenderToLabel();
	void DownloadPoster();

private:
	/* stored as a pointer to prevent blocking */
	HTTP::RequestThread* get_thread_;

	QImage img_;
	QString service_url_;
	std::string poster_url_;
	ClickableLabel label_;

	bool clickable_ = true;
	bool need_refresh_ = false;
};

#endif // MINORI_GUI_WIDGETS_POSTER_H_
