#include "gui/pages/statistics.h"
#include "core/anime_db.h"
#include "core/session.h"
#include "core/strings.h"
#include "core/time.h"
#include "gui/pages/anime_list.h"
#include "gui/widgets/graph.h"
#include "gui/widgets/text.h"

#include <QString>
#include <QTextDocument>
#include <QTextStream>
#include <QTimer>
#include <QVBoxLayout>
#include <QWidget>

#include <cmath>
#include <sstream>

StatisticsPage::StatisticsPage(QWidget* parent) : QFrame(parent) {
	setBackgroundRole(QPalette::Base);

	QVBoxLayout* layout = new QVBoxLayout(this);

	setFrameShape(QFrame::Box);
	setFrameShadow(QFrame::Sunken);

	setAutoFillBackground(true);

	_anime_list.reset(new TextWidgets::LabelledSection(
	    tr("Anime list"),
	    tr("Anime count:\nEpisode count:\nTime spent watching:\nTime to complete:\nAverage score:\nScore deviation:"),
	    "", this));
	layout->addWidget(_anime_list.get());

	{
		QWidget* score_dist_widget = new QWidget(this);
		QVBoxLayout* score_dist_layout = new QVBoxLayout(score_dist_widget);

		score_dist_layout->addWidget(new TextWidgets::Header(tr("Score distribution"), score_dist_widget));

		/* Ew */
		{
			QWidget* score_graph_parent = new QWidget(score_dist_widget);
			QVBoxLayout* score_parent_layout = new QVBoxLayout(score_graph_parent);

			_score_distribution_graph.reset(new Graph<int>(score_graph_parent));
			score_parent_layout->addWidget(_score_distribution_graph.get());

			score_parent_layout->setSpacing(0);
			score_parent_layout->setContentsMargins(12, 0, 0, 0);

			score_dist_layout->addWidget(score_graph_parent);
		}

		score_dist_layout->setContentsMargins(0, 0, 0, 0);

		layout->addWidget(score_dist_widget);
	}

	_application.reset(new TextWidgets::LabelledSection(tr("Minori"), tr("Uptime:\nRequests made:"), "\n\n", this));
	layout->addWidget(_application.get());

	layout->addStretch();

	QTimer* timer = new QTimer(this);
	connect(timer, &QTimer::timeout, this, [this] {
		if (isVisible())
			UpdateStatistics();
	});
	timer->start(1000); // update statistics every second
}

void StatisticsPage::showEvent(QShowEvent*) {
	UpdateStatistics();
}

inline int GetTotalWithScore(const int score) {
	int count = 0;
	for (const auto& item : Anime::db.items)
		if (item.second.IsInUserList() && item.second.GetUserScore() == score)
			count++;
	return count;
}

void StatisticsPage::UpdateStatistics() {
	/* Anime list */
	QString string = "";
	QTextStream ts(&string);
	ts << Anime::db.GetTotalAnimeAmount() << '\n';
	ts << Anime::db.GetTotalEpisodeAmount() << '\n';
	ts << Strings::ToQString(Time::GetSecondsAsAbsoluteString(Time::Units::Minutes, Anime::db.GetTotalWatchedAmount(), 60.0)) << '\n';
	ts << Strings::ToQString(Time::GetSecondsAsAbsoluteString(Time::Units::Minutes, Anime::db.GetTotalPlannedAmount(), 60.0)) << '\n';
	ts << Anime::db.GetAverageScore() << '\n';
	ts << Anime::db.GetScoreDeviation();
	_anime_list->GetData()->setText(string);

	_score_distribution_graph->Clear();
	for (int i = 10; i <= 100; i += 10)
		_score_distribution_graph->AddItem(i, GetTotalWithScore(i));

	string = "";
	ts << Strings::ToQString(Time::GetSecondsAsAbsoluteString(Time::Units::Seconds, session.uptime() / 1000)) << '\n';
	ts << session.GetRequests();
	/* Application */
	// UiUtils::SetPlainTextEditData(application_data, QString::number(session.uptime() / 1000));
	_application->GetData()->setText(string);
}
