#include "animone/a11y.h"

#ifdef USE_WIN32
#	include "animone/a11y/win32.h"
#endif

#ifdef USE_ATSPI
#	include "animone/a11y/atspi.h"
#endif

namespace animone::internal {

bool GetWebBrowserInformation(const Result& result, web_browser_proc_t web_browser_proc) {
	bool success = false;

#ifdef USE_WIN32
	success ^= win32::GetWebBrowserInformation(result, web_browser_proc);
#endif

#ifdef USE_ATSPI
	success ^= atspi::GetWebBrowserInformation(result, web_browser_proc);
#endif

	return success;
}

} // namespace animone::internal
