#include <gio/gio.h>
#include <cstring>

#include <iostream>

namespace glib {

bool IsInDarkTheme() {
	GSettings* settings = g_settings_new("org.gnome.desktop.interface");
	if (!settings)
		return false;

	GVariant* val = g_settings_get_value(settings, "color-scheme");
	if (!val)
		return false;

	const gchar* str;
	g_variant_get(val, "&s", &str); /* should not be freed */
	if (!str) /* how */
		return false;

	bool success = !std::strcmp(str, "prefer-dark");

	/* unref these */
	g_variant_unref(val);
	g_object_unref(settings);

	return success;
}

}
