#ifndef MINORI_CORE_HTTP_H_
#define MINORI_CORE_HTTP_H_

#include <QByteArray>
#include <QThread>
#include <string>
#include <vector>

namespace HTTP {

QByteArray Get(const std::string& url, const std::vector<std::string>& headers = {});
QByteArray Post(const std::string& url, const std::string& data, const std::vector<std::string>& headers = {});

class GetThread : public QThread {
	Q_OBJECT

public:
	GetThread(const std::string& u, const std::vector<std::string>& h = {}, QObject* parent = nullptr)
	    : QThread(parent) {
		url = u;
		headers = h;
	}

signals:
	void ReceivedData(const QByteArray& ba);

protected:
	void run() override { emit ReceivedData(Get(url, headers)); }

	std::string url;
	std::vector<std::string> headers;
};

class PostThread : public QThread {
	Q_OBJECT

public:
	PostThread(const std::string& u, const std::string& d, const std::vector<std::string>& h = {},
	           QObject* parent = nullptr)
	    : QThread(parent) {
		url = u;
		data = d;
		headers = h;
	}

signals:
	void ReceivedData(const QByteArray& ba);

protected:
	void run() override { emit ReceivedData(Post(url, data, headers)); }

	std::string url;
	std::string data;
	std::vector<std::string> headers;
};

} // namespace HTTP

#endif // MINORI_CORE_HTTP_H_
