#ifndef MINORI_CORE_SESSION_H_
#define MINORI_CORE_SESSION_H_

#include "core/config.h"
#include "core/time.h"
#include "gui/locale.h"

#include <QElapsedTimer>
#include <QObject>

#include "semver/semver.hpp"

#include <atomic>
#include <cstdint>
#include <random>
#include <string>

class MainWindow;

struct Session : public QObject {
	Q_OBJECT

public:
	Session();

	void SetMainWindow(MainWindow *window);

	void SetStatusBar(const std::string &message);

	/* we literally *cannot* be lying to the user by doing this */
	void IncrementRequests();
	std::uint32_t GetRequests();
	int uptime();

	Config config;

	std::mt19937 gen;

	static constexpr semver::version version{
	    MINORI_VERSION_MAJOR,
	    MINORI_VERSION_MINOR,
	    MINORI_VERSION_PATCH,
	};

signals:
	void StatusBarChange(const std::string &message);

private:
	/* IncrementRequests() gets called by different threads */
	std::atomic<std::uint32_t> requests_ = 0;
	QElapsedTimer timer_;
	MainWindow *window_;
};

extern Session session;

#endif // MINORI_CORE_SESSION_H_
