#include "services/services.h"
#include "core/session.h"
#include "core/strings.h"
#include "gui/translate/anime.h"
#include "services/anilist.h"
#include "services/kitsu.h"

#include <fmt/core.h>

namespace Services {

void Synchronize()
{
	session.SetStatusBar(
	    fmt::format(Strings::Translate("{}: Retrieving anime list..."), Translate::ToString(session.config.service)));

	switch (session.config.service) {
		case Anime::Service::AniList: AniList::GetAnimeList(); break;
		case Anime::Service::Kitsu: Kitsu::GetAnimeList(); break;
		default: break;
	}
}

bool RetrieveAnimeMetadata(int id)
{
	switch (session.config.service) {
		case Anime::Service::Kitsu: return Kitsu::RetrieveAnimeMetadata(id);
		default: return false;
	}
}

std::vector<int> Search(const std::string &search)
{
	session.SetStatusBar(
	    fmt::format(Strings::Translate("{}: Requesting search query..."), Translate::ToString(session.config.service)));

	switch (session.config.service) {
		case Anime::Service::AniList: return AniList::Search(search);
		case Anime::Service::Kitsu: return Kitsu::Search(search);
		default: return {};
	}
}

bool GetSeason(Anime::Season season)
{
	session.SetStatusBar(fmt::format(Strings::Translate("{}: Retrieving anime season data..."),
	                                 Translate::ToString(session.config.service)));

	switch (session.config.service) {
		case Anime::Service::AniList: return AniList::GetSeason(season);
		case Anime::Service::Kitsu: return Kitsu::GetSeason(season);
		default: return {};
	}
}

void UpdateAnimeEntry(int id)
{
	session.SetStatusBar(fmt::format(Strings::Translate("{}: Updating remote anime entry..."),
	                                 Translate::ToString(session.config.service)));

	switch (session.config.service) {
		case Anime::Service::AniList: AniList::UpdateAnimeEntry(id); break;
		case Anime::Service::Kitsu: Kitsu::UpdateAnimeEntry(id); break;
		default: break;
	}
}

}; // namespace Services
