#ifndef msvpvf_common_h
#define msvpvf_common_h

#include <stdio.h>
#include <stdint.h>
#include <stddef.h> /* size_t */
#include <stdarg.h>

/* windows clobbers ARRAYSIZE() */
#define ARRAY_SIZE(x) \
	(sizeof(x)/sizeof((x)[0]))

enum types {
	TYPES_UNKNOWN = 0,
	TYPES_VF,
	TYPES_VEG
};

extern const char *type_names[];

int set_file_information(FILE* target, uint8_t version, enum types type);
int get_file_information(FILE* input, uint8_t* version, enum types* type);
int copy_file(FILE *source, FILE *target);

/* simple malloc -> memcpy (memdup ?) */
char *str_ndup(const char *str, size_t sz);
/* str_ndup(str, strlen(str)) */
char *str_dup(const char *str);

char *msvpvf_vasprintf(const char *format, va_list ap);
char *msvpvf_asprintf(const char *format, ...);

#endif /* msvpvf_common_h */
