/**
 * "Portable" printf implementation, with some extras.
 *
 * Copyright (c) Paper 2025
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * NOTE: Floating point support is very scuffed, and doesn't
 * work for many numbers. It also depends on math.h. If you don't
 * care or don't want floating point support, toggle the #define
 * to disable it.
 *
 * EXTRA NOTE: You don't need malloc() if you turn off wide character
 * support :)
**/

#ifndef MY_PRINTF_H_
#define MY_PRINTF_H_

#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <limits.h>

/* XXX maybe we shouldn't use int as a return type. */

enum {
	MY_ENOMEM = -1, /* Out of memory */
	MY_EINVAL = -2, /* Invalid format string */
	MY_EENCOD = -3, /* Invalid wide character */
	MY_EOVERFLOW = -4, /* Return value overflows */
};

/* Get string representation of error */
const char *my_strerror(int err);

/* Free dynamically allocated memory */
void my_free(void *x);

/* ------ Actual printf stuff */

/* put function spec */
typedef void (*put_spec)(void *opaque, unsigned char c);

/* iprintf: my invention. it's basically the function that actually
 * implements everything :) */
int my_viprintf(put_spec put, void *opaque, const char *format, va_list ap);
int my_iprintf(put_spec put, void *opaque, const char *format, ...);

/* Equivalent to C99 [v]snprintf */
int my_vsnprintf(char *s, size_t n, const char *format, va_list ap);
int my_snprintf(char *s, size_t n, const char *format, ...);

/* Puts an allocated printf'd string into '*ps'. Use my_free to deallocate. */
int my_vasprintf(char **ps, const char *format, va_list ap);
int my_asprintf(char **ps, const char *format, ...);

int my_vfprintf(FILE *f, const char *fmt, va_list ap);
int my_fprintf(FILE *f, const char *fmt, ...);

int my_vprintf(const char *fmt, va_list ap);
int my_printf(const char *fmt, ...);

#endif