#include "printf.h"

#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <float.h>

int test_asprintf(void)
{
	int n, n2;
	char *s1, *s2;

	n = my_asprintf(&s1,
#include "test.h"
		);
	if (n < 0) {
		fprintf(stderr, "my_asprintf: %s\n", my_strerror(n));
		return -1;
	}
	n2 = asprintf(&s2,
#include "test.h"
		);
	if (n2 < 0) {
		my_free(s1);
		perror("asprintf");
		return -1;
	}

	if (strcmp(s1, s2) || (n != n2)) {
		fprintf(stderr, "Got different results!!\n");
		fprintf(stderr, " fprintf: %d; %s", n, s1);
		fprintf(stderr, " my_fprintf: %d; %s", n2, s2);

		my_free(s1);
		free(s2);

		return -1;
	}

	my_free(s1);
	free(s2);

	return 0;
}
