#include "printf.h"

#include <locale.h>
#include <stdlib.h> /* malloc */
#include <limits.h>
#include <stdint.h>
#include <limits.h>
#include <float.h>

int test_fprintf(void)
{
	int n, n2;
	FILE *f1, *f2;

	f1 = tmpfile();
	f2 = tmpfile();

	n = my_fprintf(f1,
#include "test.h"
		);
	if (n < 0) {
		fprintf(stderr, "my_fprintf: %s\n", my_strerror(n));
		return -1;
	}
	n2 = fprintf(f2,
#include "test.h"
		);
	if (n2 < 0) {
		perror("fprintf");
		return -1;
	}

	fseek(f1, 0, SEEK_SET);
	fseek(f2, 0, SEEK_SET);

	if (n != n2) {
		fclose(f1);
		fclose(f2);
		return -1;
	}

	for (;;) {
		int c1, c2;

		c1 = fgetc(f1);
		c2 = fgetc(f2);

		if (c1 != c2) {
			fprintf(stderr, "Got different results!!\n");
			fprintf(stderr, " fprintf @ %ld: %c", ftell(f1), c1);
			fprintf(stderr, " my_fprintf @ %ld: %c", ftell(f2), c2);

			fclose(f1);
			fclose(f2);
			return -1;
		}

		if (c1 == EOF)
			break;
	}

	fclose(f1);
	fclose(f2);

	return 0;
}