#include "printf.h"

#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <float.h>

/* This is a smaller buffer size than test.h needs, because we want to test
 * NUL-terminating behavior. */
#define BUFSZ 128

int test_snprintf(void)
{
	int n1, n2, b1, b2;
	char s1[BUFSZ], s2[BUFSZ];

	b1 = my_snprintf(NULL, 0,
#include "test.h"
		);
	if (b1 < 0) {
		fprintf(stderr, "my_snprintf(NULL, 0, ...): %s\n", my_strerror(b1));
		return -1;
	}

	b2 = snprintf(NULL, 0,
#include "test.h"
		);
	if (b2 < 0) {
		perror("snprintf(NULL, 0, ...)");
		return -1;
	}

	if (b1 != b2) {
		fprintf(stderr, "snprintf and my_snprintf returned different buffer sizes!\n");
		return -1;
	}

	n1 = my_snprintf(s1, BUFSZ,
#include "test.h"
		);
	if (n1 < 0) {
		fprintf(stderr, "my_snprintf: %s\n", my_strerror(n1));
		return -1;
	}
	n2 = snprintf(s2, BUFSZ,
#include "test.h"
		);
	if (n2 < 0) {
		my_free(s1);
		perror("snprintf");
		return -1;
	}

	if (n1 != b1) {
		fprintf(stderr, "my_snprintf with and without a buffer returned different results\n");
		return -1;
	}

	if (n1 != n2) {
		printf("snprintf and my_snprintf returned different buffer sizes\n");
		return -1;
	}

	if (strcmp(s1, s2)) {
		fprintf(stderr, "Got different results!!\n");
		fprintf(stderr, " snprintf: %s", s1);
		fprintf(stderr, " my_snprintf: %s", s2);

		return -1;
	}

	return 0;
}
