#include "vec/vec.h"

#include <stdio.h>
#include <inttypes.h>

#define ARRAY_SIZE(x) (sizeof(x)/sizeof((x)[0]))

static const int8_t testval8[] = {
	INT8_C(-80), INT8_C(-3), INT8_C(25), INT8_C(0x7F),
	INT8_C(-42), INT8_C(27), INT8_C(24), INT8_C(0x40),
};

static const uint8_t testvalu8[] = {
	UINT8_C(0x00), UINT8_C(0xFF), UINT8_C(0xFE), UINT8_C(0x7F),
	UINT8_C(0xC0), UINT8_C(0x80), UINT8_C(0x20), UINT8_C(0x50),
};

static const int16_t testval16[] = {
	INT16_C(-8000), INT16_C(-30), INT16_MAX, INT16_C(0x4000),
	INT16_C(-42),   INT16_C(250), INT16_MIN, INT16_C(0x500),
};

static const uint16_t testvalu16[] = {
	UINT16_C(0x0000), UINT16_C(0xFFFF), UINT16_C(0xFEA), UINT16_C(0x7FF),
	UINT16_C(0x7FFF), UINT16_C(0x8000), UINT16_C(0x20B), UINT16_C(0x50C),
};

static const int32_t testval32[] = {
	INT32_C(-1000000),   INT32_C(-3), INT32_C(0x00000000), INT32_C(0xFFFFFFFF),
	INT32_C(     -42),   INT32_C(27), INT32_C(0xABCDEF03), INT32_C(0x00000FFF),
	INT32_C(0xFFFFFFFF), INT32_C( 0), INT32_C(0xFFFFFFFE), INT32_C(         1),
};

static const uint32_t testvalu32[] = {
	UINT32_C(0x00000000), UINT32_C(0xDEADBEEF), UINT32_C(42), UINT32_C(0x12340000),
	UINT32_C(0xFFFFFFFF), UINT32_C(0xFEDCBA98), UINT32_C(17), UINT32_C(0x00012345),
	UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFE), UINT32_C( 0), UINT32_C(         1),
};

static const int64_t testval64[] = {
	INT64_MAX, INT64_C(-3),     INT64_C(0x00000000),   INT64_C(0xFFFFFFFFF),
	INT64_MIN, INT64_C(645366), INT64_C(0x12345ABCDE), INT64_C(0xF00000FFF),
};

static const uint64_t testvalu64[] = {
	UINT64_MAX,     UINT64_C(0x44354365), UINT64_C(0x00000000),   UINT64_C(0xFFFFFFFFF),
	UINT64_C(0xff), UINT64_C(645366),     UINT64_C(0x12345ABCDE), UINT64_C(0xF00000FFF),
};

#define VTEST(sign, bits, size) \
	static inline v##sign##int##bits##x##size vtest##sign##bits##x##size(const size_t start) \
	{ \
		sign##int##bits##_t x[size]; \
		for (size_t i = 0; i < size; i++) \
			x[i] = testval##sign##bits[(start + i) % ARRAY_SIZE(testval##sign##bits)]; \
		return v##sign##int##bits##x##size##_load(x); \
	}

#define VTEST_SIGN(bits, size) VTEST(, bits, size) VTEST(u, bits, size)

VTEST_SIGN(8, 16)
VTEST_SIGN(16, 8)
VTEST_SIGN(32, 4)
VTEST_SIGN(64, 2)

#define DEFINE_PRINT_VECTOR(sign, psign, bits, size) \
	static inline void print_v##sign##int##bits##x##size(FILE *file, v##sign##int##bits##x##size vec) \
	{ \
		fputs("vector: ", file); \
	\
		int##bits##_t v[size]; \
	\
		v##sign##int##bits##x##size##_store(vec, v); \
	\
		fprintf(file, "%" PRI ## psign ## bits, v[0]); \
	\
		for (int i = 1; i < size; i++) \
			fprintf(file, ", %" PRI ## psign ## bits, v[i]); \
	\
		fputs("\n", file); \
	\
	}

#define DEFINE_PRINT_VECTOR_2(bits, size) DEFINE_PRINT_VECTOR(, d, bits, size) DEFINE_PRINT_VECTOR(u, u, bits, size)

DEFINE_PRINT_VECTOR_2(8, 16)
DEFINE_PRINT_VECTOR_2(16, 8)
DEFINE_PRINT_VECTOR_2(32, 4)
DEFINE_PRINT_VECTOR_2(64, 2)

#include "test_align.h"
#include "test_arith.h"
#include "test_compare.h"

int main(void)
{
	int ret = 0;

	ret |= test_align();
	ret |= test_arith();
	ret |= test_compare();

	return ret;
}
