static int test_align(void)
{
	int ret = 0;

#define RUN_TEST(sign, csign, bits, size) \
	do { \
		/* allocate the aligned array */ \
		V##csign##INT##bits##x##size##_ALIGNED_ARRAY(vec_arr); \
	\
		/* fill the values */ \
		for (int i = 0; i < V##csign##INT##bits##x##size##_ALIGNED_ARRAY_LENGTH(vec_arr); i++) \
			vec_arr[i] = i; \
	\
		/* try to load it */ \
		v##sign##int##bits##x##size vec = v##sign##int##bits##x##size##_load_aligned(vec_arr); \
	\
		/* now allocate an output array */ \
		V##csign##INT##bits##x##size##_ALIGNED_ARRAY(vec_arr_out); \
	\
		/* try storing it */ \
		v##sign##int##bits##x##size##_store_aligned(vec, vec_arr_out); \
	\
		/* mark success or failure */ \
		ret |= !!memcmp(vec_arr, vec_arr_out, V##csign##INT##bits##x##size##_ALIGNED_ARRAY_LENGTH(vec_arr)); \
	} while (0);

#define RUN_TESTS(bits, size) \
	RUN_TEST( ,  , bits, size) \
	RUN_TEST(u, U, bits, size)

	RUN_TESTS(8, 16)
	RUN_TESTS(16, 8)
	RUN_TESTS(32, 4)
	RUN_TESTS(64, 2)

#undef RUN_TESTS
#undef RUN_TEST

	return ret;
}
