/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

#ifndef VEC_IMPL_X86_SSE42_H_
#define VEC_IMPL_X86_SSE42_H_

/* helper funcs */

#define MM_SET1_64(x) _mm_set1_epi64x(x)

#define VEC_xSSE42_CMP(name, op, sign, bits, size, first, second, VARS, TRANS1, TRANS2) \
	VEC_FUNC_IMPL v##sign##int##bits##x##size v##sign##int##bits##x##size##_##name(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2) \
	{ \
		VARS \
	\
		TRANS1 \
	\
		vec1.sse = _mm_##op##_epi##bits(vec##first.sse, vec##second.sse); \
	\
		TRANS2 \
	\
		return vec1; \
	}

#define VEC_SSE42_CMP(name, op, bits, size, first, second) \
	VEC_xSSE42_CMP(name, op, /* nothing */, bits, size, first, second, /* nothing */, /* nothing */, /* nothing */)

#define VEC_uSSE42_CMP(name, op, bits, size, first, second) \
	VEC_xSSE42_CMP(name, op, u, bits, size, first, second, \
		__m128i xor_val = MM_SET1_##bits(UINT64_C(1) << (bits - 1)); \
	, { \
		vec1.sse = _mm_xor_si128(vec1.sse, xor_val); \
		vec2.sse = _mm_xor_si128(vec2.sse, xor_val); \
	}, \
	{ \
		/* nothing */ \
	})

/* vint64x2 */

#ifndef VINT64x2_CMPEQ_DEFINED
VEC_xSSE42_CMP(cmpeq, cmpeq, /* nothing */, 64, 2, 1, 2, /* nothing */, /* nothing */, /* nothing */)
# define VINT64x2_CMPEQ_DEFINED
#endif

#ifndef VINT64x2_CMPLT_DEFINED
VEC_SSE42_CMP(cmplt, cmpgt, 64, 2, 2, 1)
# define VINT64x2_CMPLT_DEFINED
#endif

#ifndef VINT64x2_CMPGT_DEFINED
VEC_SSE42_CMP(cmpgt, cmpgt, 64, 2, 1, 2)
# define VINT64x2_CMPGT_DEFINED
#endif

/* vuint64x2 */

#ifndef VUINT64x2_CMPEQ_DEFINED
VEC_xSSE42_CMP(cmpeq, cmpeq, u, 64, 2, 1, 2, /* nothing */, /* nothing */, /* nothing */)
# define VUINT64x2_CMPEQ_DEFINED
#endif

#ifndef VUINT64x2_CMPLT_DEFINED
VEC_uSSE42_CMP(cmplt, cmpgt, 64, 2, 2, 1)
# define VUINT64x2_CMPLT_DEFINED
#endif

#ifndef VUINT64x2_CMPGT_DEFINED
VEC_uSSE42_CMP(cmpgt, cmpgt, 64, 2, 1, 2)
# define VUINT64x2_CMPGT_DEFINED
#endif

#endif /* VEC_IMPL_X86_SSE42_H_ */
